/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.function;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface BooleanBinaryOperator {
    public static final BooleanBinaryOperator AND = (a, b) -> a && b;
    public static final BooleanBinaryOperator OR = (a, b) -> a || b;
    public static final BooleanBinaryOperator XOR = (a, b) -> a ^ b;

    public boolean apply(boolean var1, boolean var2);

    @Contract(pure=true)
    @NotNull
    default public BooleanBinaryOperator negate() {
        return (a, b) -> !this.apply(a, b);
    }

    @NotNull
    default public BooleanBinaryOperator and(@NotNull BooleanBinaryOperator other) {
        Objects.requireNonNull(other);
        return (a, b) -> this.apply(a, b) && other.apply(a, b);
    }

    @NotNull
    default public BooleanBinaryOperator or(@NotNull BooleanBinaryOperator other) {
        Objects.requireNonNull(other);
        return (a, b) -> this.apply(a, b) || other.apply(a, b);
    }

    @NotNull
    default public BooleanBinaryOperator xor(@NotNull BooleanBinaryOperator other) {
        Objects.requireNonNull(other);
        return (a, b) -> this.apply(a, b) ^ other.apply(a, b);
    }
}

